; MODULE DESCRIPTION TYPES
; 4=COMPLETE SYSTEM

; tasm cim11
; tlink /3 /t cim11

codesg segment
  assume cs:codesg
  assume ds:codesg
  org 100h

.386

start:	jmp begin

Ctype	db 4 dup('$')
Invalid	db 0ah,0dh, ' [i] mod_i INVALID, try another.',0ah,0dh,'$'
Key_1	dd 100000h
Key_2	dd 0
Key_3	dd 0
Key_4	dd 0
Key_5	dd 0
Key_6	dd 0
Logo	db 0ah,0dh, ' ------------------------------- '
	db 0ah,0dh, '  Cimatron 11 KeyCode Validator  '
	db 0ah,0dh, '  CrackZ, 29/08/2000             '
	db 0ah,0dh, ' ------------------------------- '
	db 0ah,0dh,'$'
Mod_1	dd 0
Prompt	db 0ah,0dh, ' mod_i value (0-6) : ','$'
Testdw	dd 0
Valid	db 0ah,0dh, ' [i] mod_i VALID!, get SoftICE.',0ah,0dh,'$'

begin:	mov edx, offset Logo
	mov ah, 9
	int 21h
	mov edx, offset Prompt
	mov ah, 9
	int 21h
	mov edx, offset Ctype
	mov ah, 0ah
	int 21h
	xor ecx, ecx
	mov edx, offset Ctype.2
	mov cl, [edx]	
	sub cl, 30h ; Get %.

;-------- Find KeyCode_2 --------;

Key2:	mov eax, [Testdw]
	mov ebx, 7
	xor edx, edx
	idiv ebx
	cmp ecx, edx ; Is it the % requested?.
	jz Key2Mod_i	
	jmp Key2Loop

Key2Mod_i:
	test edx, edx
	jnz Key2Mod_ii ; Is %=0?.
	sub eax, ebx

Key2Mod_ii:
	sub eax, edx
	cmp eax, 12a5h ; 1st (has to be calculated)
	jnz Key2Loop
	mov eax, [Testdw]
	mov ebx, [Key_1]
	xor eax, ebx
	mov [Key_2], eax
	mov [Testdw], 0
	mov [Mod_1], ecx ; Store %.
	mov ecx, 4 ; MODULE DESCRIPTION (See top).
	jmp Key3

Key2Loop:
	inc dword ptr [Testdw]
	jmp Key2

;-------- Find KeyCode_3 --------;

Key3:	mov eax, [Testdw]
	mov ebx, 0bh
	xor edx, edx
	idiv ebx
	cmp ecx, edx ; Is it the % requested?.
	jz Key3Mod_i	
	jmp Key3Loop

Key3Mod_i:
	test edx, edx
	jnz Key3Mod_ii ; Is %=0?.
	sub eax, ebx

Key3Mod_ii:
	sub eax, edx
	cmp eax, 8efh ; 2nd entry
	jnz Key3Loop
	mov eax, [Testdw]
	mov ebx, [Key_2]
	xor eax, ebx
	mov [Key_3], eax
	mov [Testdw], 0
	mov ecx, [Mod_1]
	add ecx, 4 ; MODULE DESCRIPTION (See top).
	jmp Key4

Key3Loop:
	inc dword ptr [Testdw]
	jmp Key3

;-------- Find KeyCode_4 --------;

Key4:	mov eax, [Testdw]
	mov ebx, 13h
	xor edx, edx
	idiv ebx
	cmp ecx, edx ; Is it the % requested?.
	jz Key4Mod_i	
	jmp Key4Loop

Key4Mod_i:
	test edx, edx
	jnz Key4Mod_ii ; Is %=0?.
	sub eax, ebx

Key4Mod_ii:
	sub eax, edx
	cmp eax, 1028ch ; 3rd entry
	jnz Key4Loop
	mov eax, [Testdw]
	mov ebx, [Key_3]
	xor eax, ebx
	mov [Key_4], eax
	mov [Testdw], 0
	jmp Key6

Key4Loop:
	inc dword ptr [Testdw]
	jmp Key4

;-------- Find KeyCode_6 --------;

Key6:	mov eax, [Testdw]
	mov ebx, 13h
	xor edx, edx
	idiv ebx
	cmp ecx, edx
	jz Key6Mod_i
	jmp Key6Loop

Key6Mod_i:
	sub eax, edx
	cmp eax, 1018ch ; 6th entry
	jnz Key6Loop
	mov eax, [Testdw]
	mov [Key_6], eax
	mov [Testdw], 0
	mov ecx, 4 ; MODULE DESCRIPTION (See top).
	jmp Key5

Key6Loop:
	inc dword ptr [Testdw]
	jmp Key6

;-------- Find a valid KeyCode_5 --------;

Key5:	mov eax, [Testdw]
	mov ebx, 0bh
	xor edx, edx
	idiv ebx
	cmp ecx, edx
	jz Key5Mod_i
	jmp Key5Loop

Key5Mod_i:
	sub eax, edx
	cmp eax, 0f07h ; 5th entry
	jnz Key5Loop
	mov eax, [Testdw]
	mov ebx, [Key_6]
	xor eax, ebx
	mov [Key_5], eax
	mov [Testdw], 0
	jmp FinalModCheck

Key5Loop:
	inc dword ptr [Testdw]
	jmp Key5

;-------- Do final remainder check --------;

FinalModCheck:
	mov eax, [Key_5]
	mov ebx, [Key_4]
	mov ecx, [Mod_1]
	xor eax, ebx
	mov ebx, 7
	xor edx, edx
	idiv ebx
	cmp ecx, edx
	jz IsValid
	mov edx, offset Invalid
	mov ah, 9
	int 21h
	jmp Endprg

IsValid:
	mov edx, offset Valid
	mov ah, 9
	int 21h
	; int 3 ; Trap SoftICE here.
	mov eax, [Key_1]
	mov ebx, [Key_2]
	mov ecx, [Key_3]
	mov edx, [Key_4]
	mov esi, [Key_5]
	mov edi, [Key_6]

;-------- End Program --------;

Endprg:	mov eax, 4c00h
	int 21h

codesg ends
end start